IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Cajas_Movimientos') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Cajas_Movimientos
END
GO
CREATE PROCEDURE [dbo].[CPJ_Cajas_Movimientos] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON

/*Variables recibidas por parmetro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @Id_Periodo_Caja		VARCHAR(800)
DECLARE @Id_Tipo_Valor			CHAR(3)
DECLARE @Id_Moneda				CHAR(3)
DECLARE @Id_Centro_Costo		CHAR(10) 
DECLARE @Filtrar_Fecha				TINYINT 
DECLARE @Fecha_Desde			DATETIME 
DECLARE @Fecha_Hasta				DATETIME
DECLARE @Id_Tarjeta				VARCHAR(10)

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @Id_Periodo_Caja				= ISNULL(CONVERT(VARCHAR(800), dbo.CF_JSON_VALUE(@pJson,'Id_Periodo_Caja')), 0)
SET @Id_Tipo_Valor					= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Tipo_Valor')), 0)
SET @Id_Moneda						= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Moneda')), 0)
SET @Id_Centro_Costo				= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Centro_Costo')), 0)
SET @Filtrar_Fecha					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Filtrar_Fecha')), 0)
SET @Fecha_Desde					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Desde')), 0)
SET @Fecha_Hasta					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Hasta')), 0)
SET @Id_Tarjeta						= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Tarjeta')), 0)

/*FIN Variables recibidas por parmetro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @Sql			VARCHAR(MAX)
DECLARE @SqlSaldo		VARCHAR(MAX)
DECLARE @SqlSelect		VARCHAR(MAX)
DECLARE @SqlFrom		VARCHAR(MAX)
DECLARE @SqlWhere		VARCHAR(MAX)
DECLARE @SqlGroup		VARCHAR(MAX)
DECLARE @TiposValor		VARCHAR(400)
/*FIN Variable de Retorno del Stored*/

BEGIN TRY

	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Cajas_Movimientos'
		PRINT 'Parmetros:'
		PRINT 'FlagUsarTrans: ' + CONVERT(VARCHAR(10), @pFlagUsarTrans) +  'Id_Periodo_Caja: ' + CONVERT(VARCHAR(800), @Id_Periodo_Caja)  + 'Fecha_Desde:' + CONVERT(VARCHAR(10),@Fecha_Desde,103) + 'Fecha_Hasta:' + CONVERT(VARCHAR(10),@Fecha_Hasta,103)
	END


	/*===================================================================*/
	CREATE TABLE #Cajas_Mov  (Fecha DATETIME
							,Concepto VARCHAR(100)
							,Descripcion VARCHAR(300)
							,Cotizacion  DECIMAL(12,5)
							,Tipo VARCHAR(50)
							,Id_Trans INT
							,Renglon_Nro SMALLINT
							,Id_Centro_Costo CHAR(10)
							,Importe DECIMAL(16,2)
							,Imp_Valor DECIMAL(16,2)
							,Ingreso DECIMAL(16,2)
							,Egreso DECIMAL(16,2)
							,Saldo 	DECIMAL(16,2)
							,Id_Moneda char(3)
							,Comprobante_Nro INT
							,Id_Tipo_Val CHAR(3)
							,Id_Tarjeta	VARCHAR(10)
							,Id_Interno INT IDENTITY(1,1))

	CREATE TABLE #Renglon_Val_Mov (Id_Trans INT, Renglon_Nro SMALLINT)
	CREATE INDEX IX_Val_Mov____ ON  #Renglon_Val_Mov (Id_Trans)
	CREATE INDEX IX_Val_Mov2____ ON  #Renglon_Val_Mov (Renglon_Nro)

	SET @TiposValor = (SELECT Valor_String From xParametros where IdParametro = 'TVal_Consulta_Caja')

	IF @Filtrar_Fecha <> 1
	BEGIN
		SET @Filtrar_Fecha = 0
	END

	-- Calculo de maximo de renglon por transaccion para filtro de consulta principal
	SET @SqlSelect = 'SELECT R.Id_Trans, MAX(R.Renglon_Nro) AS Renglon_Nro '

	SET @SqlFrom = ' FROM Valores_Mov R
						LEFT JOIN Cbtes C ON R.Id_Trans = C.Id_Trans AND C.Id_Estado_Cbte <> 3
						LEFT JOIN Cajas_Mov CM ON R.Id_Trans = CM.Id_Trans AND CM.Id_Estado_Mov_Caja = 2
						LEFT JOIN Valores V ON R.Id_Trans = V.Id_Trans '
	IF ISNULL(@Id_Tipo_Valor,'') <> ''
	BEGIN
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND V.Id_Tipo_Val = '''+  @Id_Tipo_Valor +''''
	END
	ELSE
	BEGIN
		IF ISNULL(@TiposValor,'') <> ''
		BEGIN
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND V.Id_Tipo_Val IN (' + @TiposValor + ')'
		END
	END
	IF ISNULL(@Id_Moneda,'') <> ''
	BEGIN
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND V.Id_Moneda = ''' + @Id_Moneda + ''''
	END

	SET @SqlWhere =	' WHERE R.Id_Estado_Valor NOT IN (7,9)
							AND R.Id_Trans <> 0
							AND R.Id_Periodo_Caja IN ('+ RTRIM(LTRIM(@Id_Periodo_Caja)) +') '

	
	SET @SqlGroup = ' GROUP BY R.Id_Trans'

	SET @Sql = @SqlSelect + @SqlFrom + @SqlWhere + @SqlGroup

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Consulta Max Renglon:' + @Sql
	END
	
	INSERT INTO #Renglon_Val_Mov
	EXEC(@Sql)

	SET @Sql = ''
	SET @SqlSelect = '' 
	SET @SqlFrom = '' 
	SET @SqlWhere = '' 
	SET @SqlGroup = ''

	-- Consulta principal
	SET @SqlSelect = 'SELECT CM.FECHA as Fecha
						,ISNULL(CO.Descripcion,CMT.Descripcion)   AS Concepto
						,RTRIM(LTRIM(CM.DESCRIPCION)) + '' '' + RTRIM(LTRIM(ISNULL(C.Destinatario,''''))) as Descripcion
						,ISNULL(CASE ISNULL(T.Compromete_Trans_Fondos,0) 
								WHEN 0 THEN C.Cotizacion
								ELSE V.Cotizacion
							END,1)
							as Cotizacion
						,CMT.DESCRIPCION as Tipo 
						,CM.Id_Trans
						,CM.Renglon_Nro
						,ISNULL(C.Id_Centro_Costo,'''')
						,CM.Importe
						,SUM(V.Importe) as Imp_Valor
						,CASE ISNULL(T.COMPROMETE_BANKING,0) 
								WHEN 0 THEN 
									CASE SIGN(CM.Importe) WHEN 1 THEN SUM(V.Importe) ELSE 0 END 
								WHEN 1 THEN
									SUM(V.Importe)
								WHEN -1 THEN	
									0
								END
								as Ingreso 
						,CASE ISNULL(T.COMPROMETE_BANKING,0) 
								WHEN 0 THEN 
									CASE  SIGN(CM.Importe) WHEN -1 THEN SUM(V.Importe) ELSE 0 END 
								WHEN 1 THEN
									0
								WHEN -1 THEN	
									SUM(V.Importe)
								END
								as Egreso 
						, 0 AS Saldo
     					,V.id_moneda
						,c.Comprobante_Nro
						,ISNULL(V.Id_Tipo_Val,'''') 
						,ISNULL(V.Id_tarjeta,'''') '

	SET @SqlFrom = 'FROM Valores_mov M LEFT OUTER JOIN CBTES C ON M.Id_Trans = C.Id_Trans 
								LEFT JOIN #Renglon_Val_Mov R ON M.Id_Trans = R.Id_Trans AND M.Renglon_Nro = R.Renglon_Nro
								 LEFT OUTER JOIN CBTES_TIPOS T ON T.ID_TIPO_CBTE = C.ID_TIPO_CBTE
						 LEFT OUTER JOIN Cajas_Mov_Conceptos CMC 
								ON CMC.Id_Trans = M.Id_Trans
								  AND CMC.Item = (SELECT MIN(CMC2.Item) FROM Cajas_Mov_Conceptos CMC2 WHERE CMC2.Id_Trans = M.Id_Trans)   
						 LEFT OUTER JOIN Conceptos CO 
								ON CO.Id_Concepto = CMC.Id_Concepto
						 LEFT OUTER JOIN CAJAS_MOV CM ON CM.Id_Trans = M.Id_Trans
						 , Valores V , CAJAS_MOV_TIPOS CMT '
								

	SET @SqlWhere = ' WHERE V.Id_Valor = M.Id_valor
							AND M.Id_Periodo_Caja IN (' + RTRIM(LTRIM(@Id_Periodo_Caja)) + ')
							AND CM.Renglon_Nro = ISNULL(M.Renglon_Nro_Caja,0)
							AND CM.Id_Periodo_Caja = M.Id_Periodo_Caja 
							AND CM.Id_Estado_Mov_Caja = 2
							AND CM.Id_Trans = M.Id_Trans
							AND CM.Id_Periodo_Caja = M.Id_Periodo_Caja
							AND CMT.Id_Tipo_Mov_Caja = CM.Id_Tipo_Mov_Caja '
						 
	IF ISNULL(@Id_Tipo_Valor,'') <> ''
	BEGIN
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND V.Id_Tipo_Val = '''+  @Id_Tipo_Valor +''''
	END
	ELSE
	BEGIN
		IF ISNULL(@TiposValor,'') <> ''
		BEGIN
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND V.Id_Tipo_Val IN (' + @TiposValor + ')'
		END
	END

	IF ISNULL(@Id_Moneda,'') <> ''
	BEGIN
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND V.Id_Moneda = ''' + @Id_Moneda + ''''
	END

	IF ISNULL(@Id_Centro_Costo,'') <> ''
	BEGIN
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND C.Id_Centro_Costo = ''' + @Id_Centro_Costo +''''
	END

	IF @Filtrar_Fecha = 1
	BEGIN
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND CM.FECHA < '''+ CONVERT(VARCHAR(8),@Fecha_HASTA + 1,112) +''''
	END

	IF ISNULL(@Id_Tarjeta,'') <> ''
	BEGIN
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND V.Id_Tarjeta = ''' + @Id_Tarjeta + ''''
	END

	SET @SqlGroup = ' GROUP BY CM.FECHA
							,CM.DESCRIPCION 
							,C.Destinatario
							,C.Cotizacion
							,V.Cotizacion
							,CMT.DESCRIPCION
							,CM.Id_Trans
							,CM.Renglon_Nro
							,C.Id_Centro_Costo
							,T.Compromete_Trans_Fondos
							,CM.Importe
							,T.COMPROMETE_BANKING
							,CO.Descripcion
							,V.id_moneda
							,c.Comprobante_Nro
							,V.Id_Tipo_Val
							,V.Id_tarjeta
					ORDER BY CM.FECHA,CM.ID_TRANS '


	SET @Sql = @SqlSelect +' '+ @SqlFrom + ' ' + @SqlWhere + ' ' + @SqlGroup 
	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Consulta Principal: ' + @Sql
	END

	CREATE INDEX IX_CajaMov____ ON  #Cajas_Mov (Id_Interno)

	INSERT INTO #Cajas_Mov
	EXEC(@sql)

	DECLARE @Id_Interno INT 
	DECLARE @Ing DECIMAL(16,2)
	DECLARE @Egr DECIMAL(16,2)
	DECLARE @Saldo DECIMAL(16,2)

	SET @Saldo = 0
	DECLARE Cur_Caja CURSOR FOR
		 SELECT Id_Interno,Ingreso,Egreso FROM #Cajas_Mov order by Id_Interno

	OPEN Cur_Caja 
	FETCH NEXT FROM Cur_Caja INTO @Id_Interno,@Ing,@Egr
	WHILE @@FETCH_STATUS=0
	BEGIN

		SET @Saldo = @Saldo + @Ing - @Egr
		UPDATE #Cajas_Mov SET Saldo = @Saldo WHERE Id_Interno = @Id_Interno
		FETCH NEXT FROM Cur_Caja INTO @Id_Interno,@Ing,@Egr

	END
	CLOSE Cur_Caja
	DEALLOCATE Cur_Caja

	---------------------------------------------------------------------Creo Tabla Temporal Final en Cero---------------------------------------------------------------------------
	SELECT TOP 1 Fecha ,Concepto ,Descripcion ,Cotizacion ,Tipo ,Id_Trans ,Renglon_Nro, Id_Centro_Costo,Importe ,Imp_Valor ,Ingreso ,Egreso ,Saldo, Id_Moneda, Comprobante_Nro,Id_tipo_Val,Id_tarjeta
				 INTO #Cajas_Mov2 
				 FROM #Cajas_Mov  WHERE 1=0

	IF ISNULL(@Filtrar_Fecha,0) <> 0
	BEGIN
			IF ISNULL((SELECT COUNT(*) FROM #Cajas_Mov  WHERE  FECHA < @Fecha_Desde),0) = 0
			BEGIN        /*Cargo Saldo Anterior en cero*/
				INSERT INTO #Cajas_Mov2 ( Fecha           ,Concepto        ,Descripcion     ,Cotizacion      ,Tipo             ,Id_Trans   ,Renglon_Nro   , Id_Centro_Costo ,Importe ,Imp_Valor ,Ingreso ,Egreso ,Saldo,Id_Moneda, Comprobante_Nro,Id_tipo_Val,Id_tarjeta)
					VALUES (CAST(@Fecha_Desde - 1 AS DATE),'Saldo Anterior','Saldo Anterior',1               ,'Saldo Anterior' ,0          ,0             ,''               ,0       ,0         ,0       ,0      ,0    ,@Id_Moneda, 0,'','')
			END
			ELSE
			BEGIN        		/*Cargo Saldo Anterior*/
				INSERT INTO #Cajas_Mov2
					SELECT TOP 1 Fecha ,Concepto ,Descripcion ,Cotizacion ,Tipo ,Id_Trans ,Renglon_Nro ,Id_Centro_Costo ,Importe ,Imp_Valor ,Ingreso ,Egreso ,Saldo,Id_Moneda, Comprobante_Nro,Id_tipo_Val,Id_tarjeta
							FROM #Cajas_Mov  WHERE  FECHA < @Fecha_Desde ORDER BY Id_Interno DESC

				UPDATE #Cajas_Mov2 SET Concepto = 'Saldo Anterior', Descripcion = 'Saldo Anterior'
									 , Tipo = 'Saldo Anterior', Importe = 0,	Imp_Valor = 0, Ingreso = 0 
									 , Renglon_Nro = 0 , Id_Trans = 0
									 , Egreso = 0, Fecha = CAST(@Fecha_Desde - 1 AS DATE),Id_Moneda = @id_Moneda, Comprobante_Nro = 0,Id_tipo_Val='',Id_tarjeta=''
			END								  
	  
			/*Cargo Datos*/
			INSERT INTO #Cajas_Mov2
				 SELECT Fecha ,Concepto ,Descripcion ,Cotizacion ,Tipo ,Id_Trans ,Renglon_Nro , Id_Centro_Costo ,Importe ,Imp_Valor ,Ingreso ,Egreso ,Saldo,Id_Moneda, Comprobante_Nro,Id_tipo_Val,Id_tarjeta 
					FROM #Cajas_Mov WHERE  FECHA >= @Fecha_Desde
	END
	ELSE
	BEGIN
		/*Cargo Saldo Anterior en cero*/
		INSERT INTO #Cajas_Mov2 ( Fecha           ,Concepto        ,Descripcion     ,Cotizacion      ,Tipo             ,Id_Trans   ,Renglon_Nro , Id_Centro_Costo ,Importe ,Imp_Valor ,Ingreso ,Egreso ,Saldo,Id_moneda, Comprobante_Nro,Id_tipo_Val,Id_tarjeta)
			VALUES (CAST(@Fecha_Desde - 1 AS DATE),'Saldo Anterior','Saldo Anterior',1               ,'Saldo Anterior' ,0          ,0           ,''              ,0       ,0         ,0       ,0      ,0     ,@id_Moneda,0,'','')

		/*Cargo Datos*/		
		INSERT INTO #Cajas_Mov2
				SELECT Fecha ,Concepto ,Descripcion ,Cotizacion ,Tipo ,Id_Trans ,Renglon_Nro , Id_Centro_Costo ,Importe ,Imp_Valor ,Ingreso ,Egreso ,Saldo ,Id_Moneda, Comprobante_Nro,Id_tipo_Val,Id_tarjeta
				FROM #Cajas_Mov 

	END

	/*======================================================================================================================*/
		SELECT *,
		( SELECT TOP 1 U.LastName+' '+ U.FirstName FROM Cajas_Mov_Hist H, SEG_USER U WHERE U.NO = H.ID_USUARIO AND CM.Id_Trans = H.Id_Trans ORDER BY h.Id_Caja_Mov_Hist desc) AS Usuario,
		( SELECT TOP 1 H.FECHA FROM Cajas_Mov_Hist H, SEG_USER U WHERE U.NO = H.ID_USUARIO AND CM.Id_Trans = H.Id_Trans ORDER BY h.Id_Caja_Mov_Hist desc) AS Fecha_Mov
			 FROM #Cajas_Mov2 CM 
			 ORDER BY Fecha

		DROP TABLE #Renglon_Val_Mov
		DROP TABLE #Cajas_Mov
		DROP TABLE #Cajas_Mov2

	/*===========================================================================================*/
	IF @pFlagUsarTrans <> 0 
		BEGIN
			COMMIT
		END
		
		/*===================================================================*/	
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Fin Stored Procedure: CPJ_Cajas_Mov'
		END
	END TRY  


	BEGIN CATCH  
		EXECUTE usp_GetErrorInfo

		RETURN 9999
	END CATCH

	RETURN 0

	-- exec CP_Cajas_Movimientos '(163)','','','',,'','' 


	--SELECT * FROM #Cajas_Mov2
	 

	/*EXEC CPJ_Cajas_Movimientos '{"ModoDebug":"1"
													,"Id_Periodo_Caja":"12570"
													,"Id_Tipo_Valor":"TAR"
													,"Id_Moneda":""
													,"Id_Centro_Costo":""
													,"Filtrar_Fecha":"1"
													,"Fecha_Desde":"20200101"
													,"Fecha_Hasta":"20200331"
													,"Id_Tarjeta":"1"
													}'
*/														